/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Mar 29 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_RND.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ****************/

#include <memory.h>
#include "CryptoEngine2.h"
#include "CE2_TST_Common.h"
#include "CE2_TST_RND.h"
#include "CE2_RND.h"

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
/*********************** Private Function ***********************/
/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_ 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of CE2_RND_() function;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_RND_(FILE *out)
{
  DxStatus result = CE2_OK;

  /* 2.3.3.1. Instantiation KAT */
  DxUint8_t output[1600 >> 3] = {0};
  DxUint8_t ai[] = {0xf6,0xc4,0xfa,0x8f,0x6e,0x35,0x0c,0x37,0x4b,0x6c,0xe4,0x60,0x2d,0x03,0x5f,0x13};
  DxUint8_t ai960[] = {0x4F,0x90,0xA8,0x7D,0xFC,0xC4,0x16,0x27,0x78,0x1E,0x6F,0xF7,0xDC,0x68,0x2C,0x6A};
  DxUint8_t ai1088[] = {0xF9,0xCC,0x16,0x5D,0xF6,0x7C,0xD3,0xFD,0xC4,0x4B,0x47,0xAE,0xAC,0x5D,0xE2,0xB0};

  DxUint8_t rai[] = {0x62,0xF2,0xBC,0xE0,0x90,0x51,0x1B,0xAB,0x31,0x69,0x63,0x8E,0x17,0xD5,0xA6,0x87};

  PrintTestBeginMsg(out, __FUNCTION__);

  /*
  // spec Inst
  result = CE2_RND_AddAdditionalInput(ai, sizeof(ai));
  result = CE2_RND_Instantiation();
  result = CE2_RND_GenerateVector((64+768) >> 3, output);
  result = CE2_RND_AddAdditionalInput(ai960, sizeof(ai960));
  result = CE2_RND_GenerateVector(128 >> 3, output);
  //*/

  ///*
  // 2.3.3.2. Reseeding KAT
  result = CE2_RND_Instantiation();
  result = CE2_RND_Reseeding();
  result = CE2_RND_GenerateVector(128 >> 3, output);

  result = CE2_RND_AddAdditionalInput(rai, sizeof(rai));
  result = CE2_RND_Reseeding();
  result = CE2_RND_GenerateVector(128 >> 3, output);
  //*/

  result = CE2_RND_AddAdditionalInput(ai, sizeof(ai));
  result = CE2_RND_Instantiation();
  result = CE2_RND_GenerateVector(896 >> 3, output);

  result = CE2_RND_AddAdditionalInput(ai960, sizeof(ai960));
  result = CE2_RND_GenerateVector(960 >> 3, output);

  result = CE2_RND_GenerateVector(1024 >> 3, output);

  result = CE2_RND_AddAdditionalInput(ai1088, sizeof(ai1088));
  result = CE2_RND_GenerateVector(1088 >> 3, output);

  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}
